<?php

class NauczycielController extends Controller
{
	public $layout = 'administration';
	public $defaultAction = 'admin';

	public function init()
	{
		Yii::import('application.modules.administration.controllers.MainController');
		$mainController = new MainController('main');
		$this->menu = $mainController->getMenu();
	}

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl',
			'postOnly + delete',
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow', // allow authenticated users to perform actions
				'actions'=>array('create','update','delete','admin','view'),
				'roles'=>array('admin', 'schoolAdmin')
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model = new Admin;
		$model->setScenario('isTeacher');
		$schools = Szkola::model()->findAll();

		if(isset($_POST['Admin']))
		{
			$model->attributes = $_POST['Admin'];
			$model->rodzaj = 1;

			if($model->validate())
			{
				$model->haslo = hash('sha1', $_POST['Admin']['haslo']);

				if ($model->save(false))
					$this->redirect(array('admin'));
			}
		}

		$model->haslo = '';
		$model->hasloPowtorzone = '';

		$this->render('create', array(
			'model'=>$model,
			'schools'=>$schools
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model = $this->loadModel($id);
		$currentPassword = $model->haslo;
		$model->setScenario('isTeacherUpdate');
		$schools = Szkola::model()->findAll();

		if(isset($_POST['Admin']))
		{
			$model->attributes = $_POST['Admin'];

			if (empty($_POST['Admin']['haslo']))
			{
				$model->haslo = null;
				$model->hasloPowtorzone = null;
			}

			if($model->validate())
			{
				if(!empty($model->haslo))
					$model->haslo = hash('sha1', $model->haslo);
				else
					$model->haslo = $currentPassword;

				if ($model->save(false))
					$this->redirect(array('admin'));
			}
		}

		$model->haslo = '';
		$model->hasloPowtorzone = '';

		$this->render('update',array(
			'model'=>$model,
			'schools'=>$schools
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		try
		{
			$this->loadModel($id)->delete();
			if(!isset($_GET['ajax']))
				$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
		}
		catch(Exception $e)
		{
			throw new CHttpException(404, 'Nie można usunąć rekordu. Obiekt może być nierozerwalnie połączony z innymi elementami w bazie.');
		}
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model = new Admin('search');
		$model->unsetAttributes();

		$schoolids = Yii::app()->user->getState('schoolId');
		if(Yii::app()->user->role == 'schoolAdmin' && !empty($schoolids))
			$model->idSzkoly = Yii::app()->user->getState('schoolId');

		$model->setScenario('isTeacher');

		if(isset($_GET['Admin']))
			$model->attributes = $_GET['Admin'];

		$this->render('admin', array(
			'model'=>$model,
		));
	}

	public function actionView($id)
	{
		$model=Admin::model()->findByAttributes(array('id'=>$id,'rodzaj'=>Admin::ADMIN_TYPE_TEACHER));

		$schoolids = Yii::app()->user->getState('schoolId');
		if(Yii::app()->user->role == 'schoolAdmin' && !empty($schoolids) && $model->idSzkoly !== Yii::app()->user->getState('schoolId'))
			throw new CHttpException(403, 'Nie jesteś upoważniony do wykonania tej akcji.');

		$this->render('view',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer $id the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model = Admin::model()->findByPk($id);

		if($model === null)
			throw new CHttpException(404, Yii::t('The requested page does not exist.'));

		$schoolids = Yii::app()->user->getState('schoolId');
		if(Yii::app()->user->role == 'schoolAdmin' && !empty($schoolids) && $model->idSzkoly !== Yii::app()->user->getState('schoolId'))
			throw new CHttpException(403, 'Nie jesteś upoważniony do wykonania tej akcji.');

		return $model;
	}
}
